/*

THE PROJECT 11 (P/XI) FILE FORMAT

All P/XI files are DFF files, with the file extension 'pxi' or the HFS 
file type 'P-XI'. The DFF file format is documented separately.

P/XI will allow the creation of both project files and stack files. 
Project files and stack files are really the same thing; a stack file is 
just a project file with only one stack in it.

The DFF file includes all the stacks, backgrounds, cards, pictures, 
icons, cursors, sounds, etc. in the project. Formats for pictures, icons, 
cursors, sounds, etc. are all fairly well-documented already.

Stacks, backgrounds, cards, and report templates are referred to 
generally as "P/XI objects." All P/XI objects have the same format.



Here is the format of a P/XI object, in the format commonly seen in 
Inside Macintosh:

        +-------------------------------+
0000-   |       propertyListCount       |       2
        +-------------------------------+
0004-   |     propertyListOffset[0]     |       2
0008-   |     propertyListOffset[1]     |       2
000C-   |     propertyListOffset[2]     |       2
        /             . . .             /
        |    propertyListOffset[n-1]    |       2
        +-------------------------------+
        |                               |
        /        propertyList[0]        /       Variable
        |                               |
        +-------------------------------+
        |                               |
        /        propertyList[1]        /       Variable
        |                               |
        +-------------------------------+
        |                               |
        /        propertyList[2]        /       Variable
        |                               |
        +-------------------------------+
        |                               |
        /             . . .             /       Variable
        |                               |
        +-------------------------------+
        |                               |
        /       propertyList[n-1]       /       Variable
        |                               |
        +-------------------------------+

Offsets are from the very beginning of the data (that is, from the 
propertyListCount word).

Negative values of propertyListCount indicate that the data that 
follows is actually the compressed form of what would usually be in the 
object. The data needs to be decompressed and then processed as the object 
data. Here are the types of compression currently defined:

0xFFFFFFFF - Huffman
0xFFFFFFFE - LZRW3-A
0xFFFFFFFD - LZSS
0xFFFFFFFC - zLib 1.1.4

The first property list (propertyList[0]) in the object describes the 
object itself. Further property lists describe objects inside the 
object, which are called "parts," "buttons," or "fields" in stacks, 
backgrounds, and cards and "items" in report templates.



A property list has the following format:

        +-------------------------------+
        |                               |
        /          property[0]          /       Variable
        |                               |
        +-------------------------------+
        |                               |
        /          property[1]          /       Variable
        |                               |
        +-------------------------------+
        |                               |
        /             . . .             /       Variable
        |                               |
        +-------------------------------+
        |                               |
        /          property[n]          /       Variable
        |                               |
        +-------------------------------+

A property will always be a multiple of 4 bytes long. The first byte 
tells us the data type (and, consequentially, the length of the data), 
the second byte tells us which property it is, and the bytes after that 
store the value itself. Usually the start of the value itself snaps to a 
4-byte boundary.


Byte 0          1       2       3       4       5       6       7       8       9       10      11      Length

0x00 Boolean    Prop    Unused  Value                                                                   4
0x01 Byte       Prop    Unused  Value                                                                   4
0x02 ShortInt   Prop    Value   Value                                                                   4
0x03 RGB        Prop    Unused  Unused  Alpha   Red     Green   Blue                                    8
0x04 LongInt    Prop    Unused  Unused  Value   Value   Value   Value                                   8
0x06 RGB        Prop    Red     Red     Green   Green   Blue    Blue                                    8
0x08 Rectangle  Prop    Unused  Unused  Top     Top     Left    Left    Bottom  Bottom  Right   Right   12
0x11 Character  Prop    Unused  Char                                                                    4
0x14 Point      Prop    Unused  Unused  Y       Y       X       X                                       8
0x16 3DPoint    Prop    Z       Z       Y       Y       X       X                                       8

0x40 DFF Item   Prop    ItemID  ItemID  Symbol  Symbol  Symbol  Symbol  Symbol  Symbol  Symbol  Symbol  12
0x44 DFF Item   Prop    Unused  Unused  ItemID  ItemID  ItemID  ItemID  Symbol  ( x 8 )                 16

0x80 C String   Prop    String  >       >       >       >       >       >       >       >       >>>>    4 + Len + 1 (Null Term.)  + Align
0x81 P String   Prop    Unused  Length  String  >       >       >       >       >       >       >>>>    4 + Len +  Align
0x82 W String   Prop    Length  Length  String  >       >       >       >       >       >       >>>>    4 + Len +  Align
0x84 L String   Prop    Unused  Unused  Length  Length  Length  Length  String  >       >       >>>>    8 + Len + Align

0x91 ByteList   Prop    Count   Count   Byte1   Byte2   >       >       >       >       >       >>>>    4 + Count + Align
0x92 ShortList  Prop    Count   Count   Short1  Short1  Short2  Short2  >       >       >       >>>>    4 + 2*Count + Align
0x94 LongList   Prop    Unused  Unused  Count   Count   Count   Count   Long1   Long1   >       >>>>    8 + 4*Count


The second byte, which tells us the property, is one of the following:


0x0_ - Generic Properties

0x00    visible
0x01    enabled
0x02    partType
                0 - stack/background/card
                1 - button
                2 - field
                3 - rectangle
                4 - picture resource
                5 - picture file
                6 - icon
                7 - scroll bar
                32 and up - native control (ProcID)
0x03    style
                0 - transparent
                1 - opaque
                2 - rect
                3 - round rect
                4 - shadow
                5 - checkbox
                6 - radio button
                7 - scrolling
                8 - standard
                9 - default
                10 - oval
                11 - popup
0x04    id
0x05    rectangle
0x06    pinning
                +1 - Lock Top
                +2 - Lock Left
                +4 - Lock Bottom
                +8 - Lock Right
0x07    name
0x08    color
0x09    bevel
0x0A    dropShadow
0x0B    commandChar

0x0C    backgroundPicture
0x0D    showPict
0x0E    marked
0x0F    owner

0x1_ - Contents, Script, and State

0x10    contents
0x11    styleData
0x12    scroll
0x13    scrollBarVisible
0x14    selectedLine
0x15    lastSelectedLine
0x16    titleWidth
0x17    windowRect

0x18    scriptingLanguage
                0 - Xion
                1 - AppleScript
                2 - RBScript
                3 - JavaScript
                4 - Perl
                5 - UserTalk
                6 - QuicKeys
                (-1) - Compiled OSA Script Object
0x19    script

0x1C    minimum
0x1D    maximum
0x1E    value
0x1F    refCon

0x2_ - Button & Field Behavior

0x20    lockText
0x21    dontWrap
0x22    sharedText
0x23    autoTab
0x24    showLines
0x25    fixedLineHeight
0x26    autoSelect
0x27    multipleLines
0x28    showName
0x29    hilite
0x2A    autoHilite
0x2B    sharedHilite
0x2C    wideMargins
0x2D    family
0x2E    icon
0x2F    mouseCursor

0x3_ - Default Text Formatting

0x30    textFont
0x31    textSize
0x32    textStyle
                +1 - Bold
                +2 - Italic
                +4 - Underline
                +8 - Outline
                +16 - Shadow
                +32 - Condense
                +64 - Extend
                +128 - Group
                +256 - Superscript
                +512 - Subscript
                +1024 - Small Caps
0x33    textAlign
0x34    textHeight
0x35    textColor

0x4_ - Privileges

0x40    dontSearch
0x41    cantModify
0x42    cantDelete
0x43    cantAbort
0x44    cantPeek
0x45    privateAccess
0x46    mode
                0 - Classic
                1 - Enhanced
                2 - WildFire
0x47    userLevel
                0 - Typing with Browsing Menus
                1 - Browsing
                2 - Typing
                3 - Painting
                4 - Authoring
                5 - Scripting
                6 - Hacking
0x48    userModify

0x5_ - Report Template Properties and Report Template Item Behavior

0x50    units
0x51    margins
0x52    cellSpacing
0x53    cellSize
0x54    leftToRight
0x55    dynamicHeight
0x56    header

0x58    columns
0x59    invert
0x5A    changeTextFont
0x5B    changeTextSize
0x5C    changeTextStyle
0x5D    changeTextHeight
0x5E    changeTextColor
0x5F    border
                +1 - Top
                +2 - Left
                +4 - Bottom
                +8 - Right

0x6_ - Unused

0x7_ - Unused

0x8_ - Stack & Environment Properties

0x80    patterns
0x81    brushShapes

0x88    versionLastCreated
0x89    versionLastModified
0x8A    versionLastAccessed

0x8F    version

0x9_ - Balloon Help & Tooltips

0x90    helpString
0x91    disabledHelpString
0x92    selectedHelpString
0x93    disabledSelectedHelpString

0xA_ - Unused

0xB_ - Unused

0xC_ - Global General Properties

0xC0    lockScreen
0xC1    lockRecent
0xC2    lockMessages
0xC3    lockErrorDialogs
0xC4    longWindowTitles
0xC5    numberFormat
0xC6    editBkgnd
0xC7    soundChannel
0xC8    address
0xC9    environment
0xCA    textArrows
0xCB    suspended
0xCC    stacksInUse
0xCD    dragSpeed
0xCE    menubarVisible
0xCF    titlebarVisible

0xD_ - Global Painting & Misc Properties

0xD0    pattern
0xD1    brush
0xD2    centered
0xD3    filled
0xD4    multiple
0xD5    multiSpace
0xD6    grid
0xD7    lineSize
0xD8    polySides
0xD9    powerKeys
0xDA    dialingTime
0xDB    dialingVolume
0xDC    dialingPort
0xDD    itemDelimiter
0xDE    elementDelimiter
0xDF    listDelimiter

0xE_ - Global Script & Printing Properties

0xE0    scriptTextFont
0xE1    scriptTextSize
0xE2    scriptEditor
0xE3    debugger
0xE4    messageWatcher
0xE5    variableWatcher
0xE6    language
0xE7    traceDelay
0xE8    printTextFont
0xE9    printTextSize
0xEA    printTextStyle
                +1 - Bold
                +2 - Italic
                +4 - Underline
                +8 - Outline
                +16 - Shadow
                +32 - Condense
                +64 - Extend
                +128 - Group
                +256 - Superscript
                +512 - Subscript
                +1024 - Small Caps
0xEB    printTextAlign
0xEC    printTextHeight
0xED    printTextColor
0xEE    printMargins
0xEF    blindTyping

0xF_ - Internal P-XI Properties

0xF0    cardList
0xF1    bkgndList
0xF2    partList
0xFF    remRem



The format of property 0x11, styleData, a string, is as follows:

        +-------------------------------+
0000-   |         styleDataType         |       4
        +-------------------------------+
0004-   |                               |
        /           styleData           /       Variable
        |                               |
        +-------------------------------+

The following styleDataTypes are defined:

'WILD' - Style data as it appears inside a HyperCard stack; this is 
only useful along with the default text formatting of the part, and a font 
table and a style table extracted from the original stack and stored in 
the project file.
'HWri' - HyperWrite 1.1/1.2 style data (NOT including the text itself; 
that's still stored in property 0x10, contents).
'styl' - Macintosh standard 'styl' data.
'WTSD' - The data RealBasic returns for the TextStyleData of an 
EditField under Microsoft Windows, as (un)documented at 
http://homepage.mac.com/dnomura/RB_Win32TextStyleData.html.

*/

/* INTEGER CONSTANTS */
typedef enum _PXIPartType {			
    PXIPartTypeField			= YES,
	PXIPartTypeButton			= NO
} PXIPartType;

typedef enum _PXIPartStyle {			
    PXIPartStyleTransparent		= 0,
	PXIPartStyleOpaque			= 1,
	PXIPartStyleRect			= 2,
	PXIPartStyleRectangle		= 2,
	PXIPartStyleRoundRect		= 3,
	PXIPartStyleShadow			= 4,
	PXIPartStyleCheckBox		= 5,
	PXIPartStyleRadioButton		= 6,
	PXIPartStyleScrolling		= 7,
	PXIPartStyleStandard		= 8,
	PXIPartStyleDefault			= 9,
	PXIPartStyleOval			= 10,
	PXIPartStylePopup			= 11
} PXIPartStyle;

typedef enum _PXITextAlign {			
    PXITextAlignLeft			= 0,
	PXITextAlignCenter			= 1,
	PXITextAlignRight			= 2
} PXITextAlign;

typedef enum _PXITool {
	// Edit Modes
	PXIToolBrowse				= 0,
	PXIToolButton				= 1,
	PXIToolField				= 2,
	
	// Selectors
	PXIToolMarquee				= 3,
	PXIToolLasso				= 4,

	// Paint Tools
	PXIToolPencil				= 5,
	PXIToolBrush				= 6,
	PXIToolEraser				= 7,
	PXIToolLine					= 8,
	PXIToolSprayCan				= 9,
	PXIToolRectangle			= 10,
	PXIToolRoundRectangle		= 11,
	PXIToolPaintBucket			= 12,
	PXIToolOval					= 13,
	PXIToolFreeHand				= 14,
	PXIToolText					= 15,
	PXIToolRegularPolygon		= 16,
	PXIToolFreeHandPolygon		= 17
} PXITool;

/* NSSTRING CONSTANTS */
#define PXIAutoGetID()						[NSString stringWithFormat:@"%i",[PXIIDServer getID]]
#define PXIMakeInteger(x)					[NSNumber numberWithInt:x]

#define PXIBoolNoObject						[NSNumber numberWithBool: NO]
#define PXIBoolYesObject					[NSNumber numberWithBool: YES]

#define PXIPartTypeButtonObject				[NSNumber numberWithBool: NO]
#define PXIPartTypeFieldObject				[NSNumber numberWithBool: YES]

#define PXIPartStyleTransparentObject		[NSNumber numberWithInt:  0]
#define PXIPartStyleOpaqueObject			[NSNumber numberWithInt:  1]
#define PXIPartStyleRectObject				[NSNumber numberWithInt:  2]
#define PXIPartStyleRectangleObject			[NSNumber numberWithInt:  2]
#define PXIPartStyleRoundRectObject			[NSNumber numberWithInt:  3]
#define PXIPartStyleShadowObject			[NSNumber numberWithInt:  4]
#define PXIPartStyleCheckBoxObject			[NSNumber numberWithInt:  5]
#define PXIPartStyleRadioButtonObject		[NSNumber numberWithInt:  6]
#define PXIPartStyleScrollingObject			[NSNumber numberWithInt:  7]
#define PXIPartStyleStandardObject			[NSNumber numberWithInt:  8]
#define PXIPartStyleDefaultObject			[NSNumber numberWithInt:  9]
#define PXIPartStyleOvalObject				[NSNumber numberWithInt: 10]
#define PXIPartStylePopupObject				[NSNumber numberWithInt: 11]

#define PXITextAlignleftObject				[NSNumber numberWithInt:  0]
#define PXITextAlignCenterObject			[NSNumber numberWithInt:  1]
#define PXITextAlignRightObject				[NSNumber numberWithInt:  2]

#define PXIKeyPartName						@"partName"
#define PXIKeyPartID						@"partID"
#define PXIKeyPartNumber					@"partNumber"
#define PXIKeySpecificNumber				@"specificNumber"
#define PXIKeyPartType						@"partType"
#define PXIKeyPartStyle						@"partStyle"
#define PXIKeyContent						@"content"
#define PXIKeyHilite						@"hilite"
#define PXIKeyAutoHilite					@"autoHilite"
#define PXIKeyFontName						@"fontName"
#define PXIKeyTitleWidth					@"titleWidth"
#define PXIKeyVisible						@"visible"
#define PXIKeyEnabled						@"enabled"
#define PXIKeyShowName						@"showName"
#define PXIKeyLineWrap						@"lineWrap"
#define PXIKeyTextAlign						@"textAlign"
#define PXIKeyTextSize						@"textSize"

/* Environment Properties */
//PXITool PXIEnvironmentTool;